from playwright.sync_api import sync_playwright
import pandas as pd
import re  # Importamos re para manejar expresiones regulares

def main():
    with sync_playwright() as p:
        checkin_date = '2025-01-21'
        checkout_date = '2024-01-22'
        base_url = 'https://www.pricetravel.com/hoteles/riviera-maya'
        
        hotels_list = []

        for page_num in range(1, 19):  # Cambia el rango según la cantidad de páginas que quieras analizar
            page_url = f'{base_url}?placeId=55873&placeType=6&adults=1&checkin={checkin_date}&checkout={checkout_date}&room1.adults=1&rooms=1&ctInternal=keMzJ0Fbm2S0YUq01qXMCIqocaxsMQ_EFiglB3tm1Hc&page={page_num}'

            browser = p.chromium.launch(headless=False)
            page = browser.new_page()
            page.goto(page_url, timeout=90000)

            # Esperar a que aparezcan los elementos de hotel
            page.wait_for_selector('//a[@class="HotelCard"]', timeout=90000)
            hotels = page.locator('//a[@class="HotelCard"]').all()

            for hotel in hotels:
                hotel_dict = {}

                # Obtener el nombre del hotel
                hotel_dict['hoteles'] = hotel.locator('//h2[contains(@class, "ng-binding")]').inner_text()

                # Obtener el precio
                hotel_dict['precios'] = hotel.locator('//div[contains(@class, "footer__pricePerNight")]').inner_text()

                # Obtener la clase de estrellas usando un selector más preciso
                try:
                    star_locator = hotel.locator('//i[contains(@class, "content__stars") and contains(@class, "icon-")]')
                    if star_locator.is_visible():
                        star_class = star_locator.get_attribute("class", timeout=60000)
                        if star_class:
                            # Extraer el número de estrellas usando una expresión regular
                            match = re.search(r'icon-(\d+(\.5)?)', star_class)
                            if match:
                                hotel_dict['stars'] = match.group(1)  # Extraemos solo el número
                            else:
                                hotel_dict['stars'] = "N/A"  # Valor predeterminado si no se encuentra el número de estrellas
                        else:
                            hotel_dict['stars'] = "N/A"  # Valor predeterminado si la clase no se encuentra
                    else:
                        hotel_dict['stars'] = "N/A"  # Valor predeterminado si el elemento no es visible
                except Exception as e:
                    hotel_dict['stars'] = "N/A"  # Capturar posibles errores y asignar un valor predeterminado

                hotels_list.append(hotel_dict)

            browser.close()

        # Guardar los datos en un CSV
        df = pd.DataFrame(hotels_list)
        df.to_csv('Riviera.csv', index=False)

if __name__ == '__main__':
    main()
