from playwright.sync_api import sync_playwright
import pandas as pd

def main():
    with sync_playwright() as p:
        checkin_date = '2024-05-10'
        checkout_date = '2024-05-17'
        base_url = 'https://www.pricetravel.com/hoteles/puerto-escondido'
        
        hotels_list = []

        for page_num in range(1, 4):  # Cambia el rango según la cantidad de páginas que quieras analizar
            page_url = f'{base_url}?placeId=56255&placeType=6&adults=1&checkin={checkin_date}&checkout={checkout_date}&room1.adults=1&rooms=1&ctInternal=sM_6KXVX0Y4K9-uNCdLw35VG6csHxSXrLEWopy2n_kg&page={page_num}'

            
            browser = p.chromium.launch(headless=True)
            page = browser.new_page()
            page.goto(page_url, timeout=90000)

            hotels = page.locator('//a[@class="HotelCard"]').all()

            for hotel in hotels:
                hotel_dict = {}
                hotel_dict['hoteles'] = hotel.locator('//h2[@class="ng-binding"]').inner_text()
                hotel_dict['precios'] = hotel.locator('//div[@class="footer__pricePerNight"]').inner_text()
                #hotel_dict['stars'] = hotel.locator('//i[@class="review-score"]/div[1]').inner_text()
                #hotel_dict['avg review'] = hotel.locator('//div[@data-testid="review-score"]/div[2]/div[1]').inner_text()
                #hotel_dict['reviews count'] = hotel.locator('//div[@data-testid="review-score"]/div[2]/div[2]').inner_text().split()[0]

                hotels_list.append(hotel_dict)
            
            browser.close()

        df = pd.DataFrame(hotels_list)
        df.to_csv('Escondido.csv ', index=False)

if __name__ == '__main__':
    main()