from selenium import webdriver
from selenium.webdriver.common.by import By
from selenium.webdriver.common.keys import Keys
import pandas as pd
import time

# Configurar el ChromeDriver
driver_path = 'path/to/chromedriver'  # Especifica la ruta a tu ChromeDriver
driver = webdriver.Chrome(driver_path)

# Función para buscar negocios en Google Maps y extraer información
def scrape_google_maps(query, location):
    base_url = "https://www.google.com/maps/"
    driver.get(base_url)
    
    # Buscar el negocio en Google Maps
    search_box = driver.find_element(By.ID, "searchboxinput")
    search_box.send_keys(f"{query} en {location}")
    search_box.send_keys(Keys.RETURN)
    time.sleep(5)  # Esperar a que cargue la página
    
    # Extraer información de los resultados
    businesses = []
    business_cards = driver.find_elements(By.CLASS_NAME, "Nv2PK")

    for card in business_cards:
        try:
            name = card.find_element(By.CLASS_NAME, "qBF1Pd").text
            website = card.find_element(By.CLASS_NAME, "yYlJEf").get_attribute('href')
            businesses.append({"Name": name, "Website": website})
        except:
            continue

    return businesses

# Especificar la consulta y la ubicación
query = "restaurantes"
location = "Madrid"

# Extraer la información
businesses = scrape_google_maps(query, location)

# Convertir la lista de diccionarios a un DataFrame de Pandas
df = pd.DataFrame(businesses)

# Guardar el DataFrame a un archivo de Excel
df.to_excel("businesses.xlsx", index=False)

# Cerrar el navegador
driver.quit()
